#!/bin/sh
#
# Copy some of the libraries required to run the test application (others
# are handled by the Package tab in the CodeWarrior project).
#

##
# Utility function for file/directory copying
##

CopyFile ()  # copyCmd, source, dest
{
	/Developer/Tools/CpMac -r "$1" "$2"
}

CopyDir ()
{
	if [ -e "$2" ]; then
		/usr/bin/chflags -R nouchg "$2"
		/bin/rm -rf "$2"
	fi
	/Developer/Tools/CpMac -r "$1" "$2"
}

##
# Opera - Note, cannot be an alias or symlink, must be a copy.  
##
operaSrc="${SRCROOT}/../../third_party/opera/opera/lib/mac/Opera.app"
destination="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/MacOS/"
CopyFile "${operaSrc}" "${destination}Opera.app"

##
# APD - Note, cannot be an alias or symlink, must be a copy.  
##
apdSrc="${SRCROOT}/../../third_party/apd/mac/release/Photo Downloader.app/"
destination="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/MacOS/"
CopyFile "${apdSrc}" "${destination}Photo Downloader.app"

##
# Color Books
##
/bin/mkdir -p "${CONFIGURATION_BUILD_DIR}/Presets"
CopyFile "${SRCROOT}/../../third_party/ColorBooks" "${CONFIGURATION_BUILD_DIR}/Presets/Color Books"

##
# Photoshop plugins (so we make sure we're testing them!)
##
pluginSource="${SRCROOT}/../../third_party/PhotoshopPlugins/Mac/Plug-Ins"
pluginDest="${CONFIGURATION_BUILD_DIR}/Plug-Ins"
/bin/mkdir -p "${destination}"
CopyDir "${pluginSource}" "${pluginDest}"
pluginSource2="${SRCROOT}/../../third_party/psl/plugins/macintosh"
CopyFile "${pluginSource2}/altiveccore.plugin" "${pluginDest}"
CopyFile "${pluginSource2}/ppccore.plugin" "${pluginDest}"
CopyFile "${pluginSource2}/multiprocessor support.plugin" "${pluginDest}"
CopyFile "${pluginSource2}/mmxcore.plugin" "${pluginDest}"


##
# Photoshop Adapter
##
echo "Copy Photoshop Adapter"
pluginSource="${SRCROOT}/../../third_party/PhotoshopAdapter/Projects/XCode/build/${TARGET_NAME}/${CONFIGURATION}/Photoshop Adapter.plugin"
pluginDest="${CONFIGURATION_BUILD_DIR}/Required/Photoshop Adapter.plugin"
/bin/mkdir -p "${CONFIGURATION_BUILD_DIR}/Required"
CopyDir "${pluginSource}" "${pluginDest}"


##
# db_support
##
echo "Copy DB Support"
dbSource="${SRCROOT}/../../third_party/mysql/mac/db_support"
dbDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/db_support"
/bin/mkdir -p "${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/db_support"
CopyDir "${dbSource}" "${dbDest}"

##
#Create Webaccesslib related symlinks
##

echo "Linking libchar16 "
ln -s "webaccesslib.bundle/AdobeLibraries/libChar16.dylib" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/MacOS/

echo "Linking NetIO.framework"
ln -s "../MacOS/webaccesslib.bundle/AdobeLibraries/NetIO.framework" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/Frameworks/

echo "Linking libCoreTypes.dylib"
ln -s "webaccesslib.bundle/AdobeLibraries/libCoreTypes.dylib" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/MacOS/

echo "Linking libCrypto.dylib"
ln -s "webaccesslib.bundle/AdobeLibraries/libCrypto.dylib" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/MacOS/

echo "Linking libSSL.dylib"
ln -s "webaccesslib.bundle/AdobeLibraries/libSSL.dylib" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/MacOS/

echo "Linking libcurl.dylib"
ln -s "webaccesslib.bundle/AdobeLibraries/libcurl.3.0.0.dylib" ${CONFIGURATION_BUILD_DIR}/Bridge\ CS3.app/Contents/MacOS/


##
# Write the path to the latest build to a file in the user's folder
echo "Write LAST_BRIDGE_BUILD.txt"
bridgePath="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app"
filePath=~/LAST_BRIDGE_BUILD.txt
echo ${bridgePath} > ${filePath}

if [ "${TARGET_NAME}" = "Debug" ]; then
     targetFolder="debug"
else
     targetFolder="release"
fi

##
# Copy adobelm framework. This must be re-copied for every build because the prep tool must prep it and it must not be preped more than once.
##
echo "Copy adobelm framework"
adobelmSource="${SRCROOT}/../../third_party/amt/public/amtlib/libraries/macintosh/universal/${targetFolder}/complete/adobelm.framework"
adobelmDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Frameworks/adobelm.framework"
# /bin/mkdir -p "${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Frameworks/adobelm.framework"
CopyDir "${adobelmSource}" "${adobelmDest}"
chmod a=rwx "${adobelmDest}/Versions/A/adobelm"

##
# Copy AMTLib resources
##
echo "Copy AMTLib resources"
amtSource="${SRCROOT}/../../third_party/amt/public/amtlib/config/AMT"
amtDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Resources/AMT"
# /bin/mkdir -p "${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Resources/AMT"
CopyDir "${amtSource}" "${amtDest}"

##
# Copy ifnp. 
##
echo "Copy ifnp"
ifnpSource="${SRCROOT}/../../third_party/amt/public/amtlib/libraries/macintosh/universal/${targetFolder}/complete/ifnp"
ifnpDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Resources/AMT"
CopyFile "${ifnpSource}" "${ifnpDest}"

##
# Copy Bridge Owned AMT resources
##
echo "Copy Bridge owned AMTLib resources"
amtBridgeSource="${SRCROOT}/../../source/resources/AMT/mac"
amtBridgeDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Resources/AMT"
CopyFile "${amtBridgeSource}/application.xml" "${amtBridgeDest}"
CopyFile "${amtBridgeSource}/../AUMProduct.cer" "${amtBridgeDest}"
chmod 0774 "${amtBridgeDest}/AUMProduct.cer"

##
# Run the prep tool
##
echo "Running the prep tool"
prepBridgeSource="${SRCROOT}/../../source/resources/AMT/mac"
prepBridgeDest="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/MacOS"
CopyFile "${prepBridgeSource}/bridge_prepconfig.xml" "${prepBridgeDest}"

prepBridgeSource="${SRCROOT}/../../third_party/amt/public/amtlib/binaries/macintosh/preptool"

CopyFile "${prepBridgeSource}/publisher.xml" "${prepBridgeDest}"
CopyFile "${prepBridgeSource}/preparchive_11.03.005.yaa" "${prepBridgeDest}"
CopyFile "${prepBridgeSource}/preptool" "${prepBridgeDest}"

cd "${prepBridgeDest}"

./preptool -v bridge_prepconfig.xml

/bin/rm -f preptool
/bin/rm -f preparchive_*.*
/bin/rm -f publisher.xml
/bin/rm -f bridge_prepconfig.xml

